// SC540Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC540.h"
#include "SC540Dlg.h"

#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC540_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC540] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

ULONG g_n_video_frame_number[ 4 ] = { 0, 0, 0, 0 };

ULONG g_n_video_main_encoder_frame_number[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_start_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_main_encoder_start_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_stop_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_main_encoder_stop_sample_time[ 4 ] = { 0, 0, 0, 0 };

ULONGLONG g_n_video_main_encoder_stream_size[ 4 ] = { 0, 0, 0, 0 };

BOOL g_b_is_start_statistics = FALSE;

BOOL on_process_video_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC540Dlg *      pMainDialog = (CSC540Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_LIVE[ i ]);

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000000) ? TRUE : FALSE;

	// VISION ALGORITHM PRGRAMMING (EXTRA LICENSE)

	if( g_b_is_start_statistics ) {

		if( g_n_video_frame_number[ i ]++ == 0 ) { 
			
			g_d_video_start_sample_time[ i ] = dSampleTime; }

		g_d_video_stop_sample_time[ i ] = dSampleTime;
	}
	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_video_main_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC540Dlg *      pMainDialog = (CSC540Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_H264_MAIN[ i ]);

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000002) ? TRUE : FALSE;

	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000002) ? TRUE : FALSE;

	BOOL             bIsStreaming = (pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000002) ? TRUE : FALSE;

	if( bIsKeyFrame ) {

		if( pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000001 ) { // WAITING KEY FRAME

			pMainDialog->m_nFileRendererRecordState[ i ] = 0x00000002; // TO GOTO START STATE

			bIsRecord = TRUE;
		}

		if( pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000001 ) { // WAITING KEY FRAME

			pMainDialog->m_nNetworkRendererStreamingState[ i ] = 0x00000002; // TO GOTO START STATE

			bIsStreaming = TRUE;
		}
	}

	ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

	if( bIsRecord ) {		

		AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev[ i ], pBuffer, nBufferLen, bIsKeyFrame, 0, nSampleTime );
	}

	if( bIsStreaming ) { 

		ULONG n_buffer_queue_size = 0;

		ULONG n_frame_queue_size = 0;

		ULONG n_clients = 0;

		AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS( pMainDialog->m_hNetworkRendererDev, i, &n_buffer_queue_size, &n_frame_queue_size, &n_clients ); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

		AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER( pMainDialog->m_hNetworkRendererDev, i, pBuffer, nBufferLen,  bIsKeyFrame,  0, nSampleTime );
	}

	if( g_b_is_start_statistics ) {

//		SYSTEMTIME s_system_times; GetLocalTime( &s_system_times );

//		ULONGLONG n_system_time = 0; SystemTimeToFileTime( &s_system_times, (FILETIME *)(&n_system_time) );

//		dSampleTime = (ULONG)(n_system_time / 10000) / 1000.0;

		if( g_n_video_main_encoder_frame_number[ i ]++ == 0 ) { g_d_video_main_encoder_start_sample_time[ i ] = dSampleTime; }

		g_d_video_main_encoder_stop_sample_time[ i ] = dSampleTime;

		g_n_video_main_encoder_stream_size[ i ] += nBufferLen;
	}
	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_audio_buffer_ex( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC540Dlg *      pMainDialog = (CSC540Dlg *)(pUserData);

	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000002) ? TRUE : FALSE;

	BOOL             bIsStreaming = (pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000002) ? TRUE : FALSE;

	ULONGLONG nSampleTime = (ULONGLONG)(dSampleTime * 10000000);

	if( bIsRecord ) {			

		AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev[ i ], pBuffer, nBufferLen, 0, nSampleTime );			
	}

	if( bIsStreaming ) { 

		AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER( pMainDialog->m_hNetworkRendererDev, i, pBuffer, nBufferLen, 0, nSampleTime );
	}

	return TRUE;
}

BOOL on_process_audio_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	BOOL returns = on_process_audio_buffer_ex( nChannelNumber, dSampleTime, pBuffer, (nBufferLen >> 1), bIsKeyFrame, pUserData );

	double ts = (nBufferLen >> 1);

	ts /= 192000;

	returns = on_process_audio_buffer_ex( nChannelNumber, dSampleTime + ts, pBuffer + (nBufferLen >> 1), (nBufferLen >> 1), bIsKeyFrame, pUserData );

	return returns;
}

BOOL on_process_video_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC540Dlg dialog

CRect g_rect_channel_window_topology_01_960[ 1 ] = { CRect(       0,       0,       960,       540 )  // FULLSCREEN
};
CRect g_rect_channel_window_topology_04_960[ 4 ] = { CRect(       0,       0,       480,       270 ), // QUAD

													 CRect(     480,       0,       960,       270 ), // QUAD

													 CRect(       0,     270,       480,       540 ), // QUAD

													 CRect(     480,     270,       960,       540 )  // QUAD
};

CSC540Dlg::CSC540Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC540Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC540Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoDev[ 3 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF;

	m_hAudioDev[ 0 ] = 0xFFFFFFFF;

	m_hAudioDev[ 1 ] = 0xFFFFFFFF;

	m_hAudioDev[ 2 ] = 0xFFFFFFFF;

	m_hAudioDev[ 3 ] = 0xFFFFFFFF;	

	m_hFileRendererDev[ 0 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 1 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 2 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 3 ] = 0xFFFFFFFF;

	m_nFileRendererRecordState[ 0 ] = 0x00000000;

	m_nFileRendererRecordState[ 1 ] = 0x00000000;

	m_nFileRendererRecordState[ 2 ] = 0x00000000;

	m_nFileRendererRecordState[ 3 ] = 0x00000000;

	m_hFileSourceDev[ 0 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 1 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 2 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 3 ] = 0xFFFFFFFF;

	m_hNetworkRendererDev = 0xFFFFFFFF;

	m_nNetworkRendererStreamingState[ 0 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 1 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 2 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 3 ] = 0x00000000;
}

void CSC540Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC540Dlg)
	DDX_Control(pDX, IDC_TAB_DISPLAY, m_tabDisplayExchange);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC540Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC540Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_DISPLAY, OnSelChangeTabDisplay)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC540Dlg message handlers

void CSC540Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC540Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC540Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CSC540Dlg::HwUnInitialize()
{
	// STOP RECORDING & STREAMING
	//
	{	m_nFileRendererRecordState[ 0 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 1 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 2 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 3 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 0 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 1 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 2 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 3 ] = 0x00000000; // STOP STATE
	}
	// UNINITIALIZE DEVICE RESOURCE
	//
	{	if( m_hVideoDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 0 ] ); m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 1 ] ); m_hVideoDev[ 1 ] = 0xFFFFFFFF; }
		
		if( m_hVideoDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 2 ] ); m_hVideoDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 3 ] ); m_hVideoDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 0 ] ); m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 1 ] ); m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 2 ] ); m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 3 ] ); m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF; }
		
		if( m_hAudioDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 0 ] ); m_hAudioDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 1 ] ); m_hAudioDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 2 ] ); m_hAudioDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 3 ] ); m_hAudioDev[ 3 ] = 0xFFFFFFFF; }		
	}
	// UNINITIALIZE FILE RENDERER RESOURCE
	//
	{	if( m_hFileRendererDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 0 ] ); m_hFileRendererDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 1 ] ); m_hFileRendererDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 2 ] ); m_hFileRendererDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 3 ] ); m_hFileRendererDev[ 3 ] = 0xFFFFFFFF; }
	}
	// UNINITIALIZE FILE SOURCE RESOURCE
	//
	{	if( m_hFileSourceDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 0 ] ); m_hFileSourceDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 1 ] ); m_hFileSourceDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 2 ] ); m_hFileSourceDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 3 ] ); m_hFileSourceDev[ 3 ] = 0xFFFFFFFF; }
	}
	// UNINITIALIZE NETWORK RESOURCE
	//
	if( m_hNetworkRendererDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkRendererDev ); m_hNetworkRendererDev = 0xFFFFFFFF; }

	return TRUE;
}

void CSC540Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000001 );

	KillTimer( 0x00000000 );

	// UNINITIALIZE DEVICE RESOURCE
	//
	HwUnInitialize();	
	
	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindow_LIVE[ 0 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 1 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 2 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 3 ].DestroyWindow();

		m_oChannelWindow_FILE[ 0 ].DestroyWindow();

		m_oChannelWindow_FILE[ 1 ].DestroyWindow();

		m_oChannelWindow_FILE[ 2 ].DestroyWindow();

		m_oChannelWindow_FILE[ 3 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 0 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 1 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 2 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 3 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}	
}

BOOL CSC540Dlg::HwInitialize()
{
	// GET DEVICE PARAMETERS FROM SETUP DIALOG
	//
	ULONG standard = { 0 };

	ULONG cx[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG cy[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG deinterlace[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	double fps[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG mode[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG bitrate[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG quality[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG gop[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG bframe[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	CHAR path[ MAX_PATH ];

	m_oSetupDialog.GetStandardParameters( &standard );

	m_oSetupDialog.GetResolutionParameters( cx, cy );

	m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

	m_oSetupDialog.GetFrameRateParameters( fps );

	m_oSetupDialog.GetRecordModeParameters( mode );

	m_oSetupDialog.GetBitRateParameters( bitrate );

	m_oSetupDialog.GetQualityParameters( quality );

	m_oSetupDialog.GetGOPParameters( gop );

	m_oSetupDialog.GetBFrameParameters( bframe );

	m_oSetupDialog.GetRecordPathParameters( path );

	// INITIALIZE NETWORK RESOURCE
	//
	{	m_hNetworkRendererDev = AMESDK_CREATE( "Common Analog Network Renderer streams=4", 0, 5, NULL, NULL, NULL );

		if( m_hNetworkRendererDev & 0x80000000 ) {
			
			m_hNetworkRendererDev = 0xFFFFFFFF;
		}
		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 0, MAKEFOURCC('H', '2', '6', '4'), cx[ 0 ], cy[ 0 ], 24, fps[ 0 ], bitrate[ 0 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 1, MAKEFOURCC('H', '2', '6', '4'), cx[ 1 ], cy[ 1 ], 24, fps[ 1 ], bitrate[ 1 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 2, MAKEFOURCC('H', '2', '6', '4'), cx[ 2 ], cy[ 2 ], 24, fps[ 2 ], bitrate[ 2 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 3, MAKEFOURCC('H', '2', '6', '4'), cx[ 3 ], cy[ 3 ], 24, fps[ 3 ], bitrate[ 3 ] * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 0, 0x00000000 /*PCM*/, 2, 16, 48000, 2 * 16 * 48000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 1, 0x00000000 /*PCM*/, 2, 16, 48000, 2 * 16 * 48000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 2, 0x00000000 /*PCM*/, 2, 16, 48000, 2 * 16 * 48000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 3, 0x00000000 /*PCM*/, 2, 16, 48000, 2 * 16 * 48000 * 4 );

		AMESDK_NETWORK_SET_USER_ACCOUNT( m_hNetworkRendererDev, "root", "root" );

		AMESDK_NETWORK_SET_STREAMING_PORT( m_hNetworkRendererDev, 554 );
	}
	// INITIALIZE FILE RESOURCE
	//
	{	SYSTEMTIME system_times; 
	
		CHAR psz[ MAX_PATH ];

		GetLocalTime( &system_times );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			sprintf( psz, "Common Analog File Renderer %sCH%02d\\%04d%02d%02d%02d%02d%02d.MP4", path, i + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			m_hFileRendererDev[ i ] = AMESDK_CREATE( psz, i, 3, NULL, NULL, NULL ); // CH#0X

			if( m_hFileRendererDev[ i ] & 0x80000000 ) {
				
				m_hFileRendererDev[ i ] = 0xFFFFFFFF;
			}
			AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cx[ i + 0 ], cy[ i + 0 ], 24, fps[ i + 0 ], 0x00000000 ); // RESOLUTION / FRAMERATE

			AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hFileRendererDev[ i ], 0x00000000, 2, 16, 48000 ); // PCM / STEREO / 16BITS / 48000HZ
		}
	}
	// INITIALIZE DEVICE RESOURCE
	//
	{	HWND wnd[ 16 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

		PF_BUFFER_CALLBACK bcb[ 16 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };
		
		PVOID params[ 16 ] = { this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this };

		///////////////////////////////////////////////////////////

		wnd[  0 ] = m_oChannelWindow_LIVE[ 0 ].m_hWnd;

		wnd[  1 ] = m_oChannelWindow_LIVE[ 1 ].m_hWnd;

		wnd[  2 ] = m_oChannelWindow_LIVE[ 2 ].m_hWnd;

		wnd[  3 ] = m_oChannelWindow_LIVE[ 3 ].m_hWnd;

		wnd[  4 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  5 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  6 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  7 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  8 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  9 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 10 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 11 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 12 ] = NULL; // DISABLE REALTIME PLAYBACK OF AUDIO STREAM.

		wnd[ 13 ] = NULL; // DISABLE REALTIME PLAYBACK OF AUDIO STREAM.

		wnd[ 14 ] = NULL; // DISABLE REALTIME PLAYBACK OF AUDIO STREAM.

		wnd[ 15 ] = NULL; // DISABLE REALTIME PLAYBACK OF AUDIO STREAM.

		bcb[  0 ] = on_process_video_buffer_CH01;

		bcb[  1 ] = on_process_video_buffer_CH02;

		bcb[  2 ] = on_process_video_buffer_CH03;

		bcb[  3 ] = on_process_video_buffer_CH04;

		bcb[  4 ] = on_process_video_main_encoder_buffer_CH01;

		bcb[  5 ] = on_process_video_main_encoder_buffer_CH02;

		bcb[  6 ] = on_process_video_main_encoder_buffer_CH03;

		bcb[  7 ] = on_process_video_main_encoder_buffer_CH04;

		bcb[ 12 ] = on_process_audio_buffer_CH01;

		bcb[ 13 ] = on_process_audio_buffer_CH02;

		bcb[ 14 ] = on_process_audio_buffer_CH03;

		bcb[ 15 ] = on_process_audio_buffer_CH04;

		#if ( SC540_REALTIME_PLAYBACK_ENABLE == 1 )	        // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAMS. (RTPB)

		wnd[  4 ] = m_oChannelWindow_H264_MAIN[ 0 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  5 ] = m_oChannelWindow_H264_MAIN[ 1 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  6 ] = m_oChannelWindow_H264_MAIN[ 2 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  7 ] = m_oChannelWindow_H264_MAIN[ 3 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		#endif

		/////////////////////////////////////////////////////////////////////////////////////////////////

		m_hVideoDev[ 0 ] = AMESDK_CREATE( "QP0203 PCI", 0, 0, wnd[ 0 ], bcb[ 0 ], params[ 0 ] ); // CH#01

		m_hVideoDev[ 1 ] = AMESDK_CREATE( "QP0203 PCI", 1, 0, wnd[ 1 ], bcb[ 1 ], params[ 1 ] ); // CH#02

		m_hVideoDev[ 2 ] = AMESDK_CREATE( "QP0203 PCI", 2, 0, wnd[ 2 ], bcb[ 2 ], params[ 2 ] ); // CH#03

		m_hVideoDev[ 3 ] = AMESDK_CREATE( "QP0203 PCI", 3, 0, wnd[ 3 ], bcb[ 3 ], params[ 3 ] ); // CH#04

		m_hVideoMainEncoderDev[ 0 ] = AMESDK_CREATE( "QP0203 PCI, Analog Encoder", 0, 0, wnd[ 4 ], bcb[ 4 ], params[ 4 ] ); // CH#01

		m_hVideoMainEncoderDev[ 1 ] = AMESDK_CREATE( "QP0203 PCI, Analog Encoder", 1, 0, wnd[ 5 ], bcb[ 5 ], params[ 5 ] ); // CH#02

		m_hVideoMainEncoderDev[ 2 ] = AMESDK_CREATE( "QP0203 PCI, Analog Encoder", 2, 0, wnd[ 6 ], bcb[ 6 ], params[ 6 ] ); // CH#03

		m_hVideoMainEncoderDev[ 3 ] = AMESDK_CREATE( "QP0203 PCI, Analog Encoder", 3, 0, wnd[ 7 ], bcb[ 7 ], params[ 7 ] ); // CH#04

		m_hAudioDev[ 0 ] = AMESDK_CREATE( "QP0203 PCI, Analog WaveIn", 0, 0, wnd[ 12 ], bcb[ 12 ], params[ 12 ] ); // CH#01

		m_hAudioDev[ 1 ] = AMESDK_CREATE( "QP0203 PCI, Analog WaveIn", 1, 0, wnd[ 13 ], bcb[ 13 ], params[ 13 ] ); // CH#02

		m_hAudioDev[ 2 ] = AMESDK_CREATE( "QP0203 PCI, Analog WaveIn", 2, 0, wnd[ 14 ], bcb[ 14 ], params[ 14 ] ); // CH#03

		m_hAudioDev[ 3 ] = AMESDK_CREATE( "QP0203 PCI, Analog WaveIn", 3, 0, wnd[ 15 ], bcb[ 15 ], params[ 15 ] ); // CH#04		

		if( m_hVideoDev[ 0 ] & 0x80000000 ) { m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] & 0x80000000 ) { m_hVideoDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 2 ] & 0x80000000 ) { m_hVideoDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 3 ] & 0x80000000 ) { m_hVideoDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 0 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 1 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 2 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 3 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 0 ] & 0x80000000 ) { m_hAudioDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 1 ] & 0x80000000 ) { m_hAudioDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 2 ] & 0x80000000 ) { m_hAudioDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 3 ] & 0x80000000 ) { m_hAudioDev[ 3 ] = 0xFFFFFFFF; }		

		// SETUP LIVE PATH (YV12) PROPERTIES
		// 
		for( ULONG i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_STANDARD( m_hVideoDev[ i ], standard ); // STANDARD

			if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ i ], MAKEFOURCC('Y', 'V', '1', '2'), cx[ i ], cy[ i ], 12, 29.97 ); } // RESOLUTION = 1920  1088  29.97 / NTSC

			if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ i ], MAKEFOURCC('Y', 'V', '1', '2'), cx[ i ], cy[ i ], 12, 25.00 ); } // RESOLUTION = 1920  1088  25.00 / PALB

			AMESDK_SET_DEINTERLACE( m_hVideoDev[ i ], deinterlace[ i ] );
		}
		// SETUP RECORDING PATH (H.264) PROPERTIES
		// 
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_STANDARD( m_hVideoMainEncoderDev[ i ], standard ); // STANDARD

			AMESDK_SET_FORMAT( m_hVideoMainEncoderDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cx[ i ], cy[ i ], 24, fps[ i ] ); // RESOLUTION / FRAMERATE
			
			AMESDK_SET_DEINTERLACE( m_hVideoMainEncoderDev[ i ], deinterlace[ i ] );

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000003, mode[ i ] ); // RECORD MODE

			if( mode[ i ] == 0 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000001, quality[ i ] ); } // QUALITY (VBR)

			if( mode[ i ] == 1 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000004, bitrate[ i ] ); } // BITRATE (CBR)

			if( mode[ i ] == 2 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000001, quality[ i ] ); } // QUALITY (HBR)

			if( mode[ i ] == 2 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000004, bitrate[ i ] ); } // BITRATE (HBR)
		
			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000000, gop[ i ] ); // GOP

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x0000000A, bframe[ i ] ); // BFRAME
		}
		// SETUP AUDIO PATH (PCM) PROPERTIES
		//
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_FORMAT( m_hAudioDev[ i ], 2, 16, 48000 ); // STEREO / 16BITS / 48000HZ
		}
		
		// START
		//
		for( i = 0 ; i < 4 ; i++ ) {

			g_n_video_frame_number[ i ] = 0;

			g_n_video_main_encoder_frame_number[ i ] = 0;

			g_d_video_start_sample_time[ i ] = 0;

			g_d_video_main_encoder_start_sample_time[ i ] = 0;

			g_d_video_stop_sample_time[ i ] = 0;

			g_d_video_main_encoder_stop_sample_time[ i ] = 0;

			g_n_video_main_encoder_stream_size[ i ] = 0;

			g_b_is_start_statistics = FALSE;
		}
	
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_RUN( m_hVideoDev[ i ] );			

			AMESDK_RUN( m_hVideoMainEncoderDev[ i ] );

			AMESDK_RUN( m_hAudioDev[ i ] );
		}

		Sleep( 512 );

		g_b_is_start_statistics = TRUE;

		// HERE, EVERY CHANNEL SHOULD OUTPUT 3 BITSTREAMS: LIVE + H.264 + AUDIO
	}
	// START RECORDING
	//
	{	m_nFileRendererRecordState[ 0 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 1 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 2 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 3 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
	}
	// START STREAMING
	//
	{	if( m_hNetworkRendererDev      != 0xFFFFFFFF ) { AMESDK_RUN( m_hNetworkRendererDev ); }

		m_nNetworkRendererStreamingState[ 0 ] = 0x00000001;

		m_nNetworkRendererStreamingState[ 1 ] = 0x00000001;

		m_nNetworkRendererStreamingState[ 2 ] = 0x00000001;

		m_nNetworkRendererStreamingState[ 3 ] = 0x00000001;
	}
	return TRUE;
}

BOOL CSC540Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = 10; // SET CUSTOM BOUNDARY WIDTH OF TAB CONTROL

		ULONG ty = 32; // SET CUSTOM BOUNDARY HEIGHT OF TAB CONTROL

		SetWindowPos( &(CWnd::wndTop), 0, 0, 960 + (cx) + (tx + tx), 540 + (cy) + (ty + tx), SWP_NOMOVE );

		m_tabDisplayExchange.MoveWindow( 0, 0, 960 + (tx + tx), 540 + (ty + tx) );

		m_tabDisplayExchange.InsertItem( 0, "LIVE DISPLAY" );

		m_tabDisplayExchange.InsertItem( 1, "RECORD PLAYBACK" );

		#if ( SC540_REALTIME_PLAYBACK_ENABLE == 1 )

		m_tabDisplayExchange.InsertItem( 2, "REALTIME PLAYBACK (MAIN)" );

		#endif

		m_nDisplayModeNumber = 0x00000000;

		{	g_rect_channel_window_topology_01_960[ 0 ].top += ty; g_rect_channel_window_topology_01_960[ 0 ].bottom += ty; g_rect_channel_window_topology_01_960[ 0 ].left += tx; g_rect_channel_window_topology_01_960[ 0 ].right += tx;

			g_rect_channel_window_topology_04_960[ 0 ].top += ty; g_rect_channel_window_topology_04_960[ 0 ].bottom += ty; g_rect_channel_window_topology_04_960[ 0 ].left += tx; g_rect_channel_window_topology_04_960[ 0 ].right += tx;

			g_rect_channel_window_topology_04_960[ 1 ].top += ty; g_rect_channel_window_topology_04_960[ 1 ].bottom += ty; g_rect_channel_window_topology_04_960[ 1 ].left += tx; g_rect_channel_window_topology_04_960[ 1 ].right += tx;

			g_rect_channel_window_topology_04_960[ 2 ].top += ty; g_rect_channel_window_topology_04_960[ 2 ].bottom += ty; g_rect_channel_window_topology_04_960[ 2 ].left += tx; g_rect_channel_window_topology_04_960[ 2 ].right += tx;

			g_rect_channel_window_topology_04_960[ 3 ].top += ty; g_rect_channel_window_topology_04_960[ 3 ].bottom += ty; g_rect_channel_window_topology_04_960[ 3 ].left += tx; g_rect_channel_window_topology_04_960[ 3 ].right += tx;
		}
		m_oChannelWindow_LIVE[ 0 ].Create( NULL, "MyChannelWindow#LIVE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 0 ], this, 0x00000001, NULL );

		m_oChannelWindow_LIVE[ 1 ].Create( NULL, "MyChannelWindow#LIVE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 1 ], this, 0x00000002, NULL );

		m_oChannelWindow_LIVE[ 2 ].Create( NULL, "MyChannelWindow#LIVE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 2 ], this, 0x00000003, NULL );

		m_oChannelWindow_LIVE[ 3 ].Create( NULL, "MyChannelWindow#LIVE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 3 ], this, 0x00000004, NULL );

		m_oChannelWindow_FILE[ 0 ].Create( NULL, "MyChannelWindow#FILE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 0 ], this, 0x10000001, NULL );

		m_oChannelWindow_FILE[ 1 ].Create( NULL, "MyChannelWindow#FILE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 1 ], this, 0x10000002, NULL );

		m_oChannelWindow_FILE[ 2 ].Create( NULL, "MyChannelWindow#FILE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 2 ], this, 0x10000003, NULL );

		m_oChannelWindow_FILE[ 3 ].Create( NULL, "MyChannelWindow#FILE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 3 ], this, 0x10000004, NULL );

		m_oChannelWindow_H264_MAIN[ 0 ].Create( NULL, "MyChannelWindow#H264#MAIN#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 0 ], this, 0x20000001, NULL );

		m_oChannelWindow_H264_MAIN[ 1 ].Create( NULL, "MyChannelWindow#H264#MAIN#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 1 ], this, 0x20000002, NULL );

		m_oChannelWindow_H264_MAIN[ 2 ].Create( NULL, "MyChannelWindow#H264#MAIN#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 2 ], this, 0x20000003, NULL );

		m_oChannelWindow_H264_MAIN[ 3 ].Create( NULL, "MyChannelWindow#H264#MAIN#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_960[ 3 ], this, 0x20000004, NULL );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );

		SetTimer( 0x00000000, 0, NULL );

		SetTimer( 0x00000001, 1000, NULL );
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC540Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSC540Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CSC540Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	// USER INTERFACE RELATED PROGRAMMING
	//
	if( nIDEvent == 0x00000000 ) {

		HMONITOR hMonitor = NULL;

		MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), };

		hMonitor = MonitorFromPoint( CPoint( 0, 0 ), MONITOR_DEFAULTTOPRIMARY ); // GET FIRST MONITOR

		GetMonitorInfo( hMonitor, &sMonitorInfo );

		ULONG sx = (sMonitorInfo.rcMonitor.right - sMonitorInfo.rcMonitor.left);

		ULONG sy = (sMonitorInfo.rcMonitor.bottom - sMonitorInfo.rcMonitor.top);

		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = (1056 - 960 - 20) >> 1;

		m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

		m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), oWindowRect.left - tx, sy - 230 + 5 - 50, cx + 1056, cy + 230, NULL );

		m_oSetupDialog.ShowWindow( TRUE );

		SetWindowPos( NULL, oWindowRect.left, 5, 0, 0, SWP_NOSIZE | SWP_NOZORDER );

		SetFocus();

		m_oSetupDialog.UpdateWindow();

		KillTimer( 0x00000000 );

		// INITIALIZE DEVICE RESOURCE
		//
		HwInitialize();
	}

	/*
	if( nIDEvent == 0x00000001 ) {

		double fps[ 12 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

		double bps[ 12 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

		if( g_n_video_frame_number[ 0 ]              > 0 ) { fps[  0 ] = (g_d_video_stop_sample_time[ 0 ]              - g_d_video_start_sample_time[ 0 ]             ) / (g_n_video_frame_number[ 0 ]); }

		if( g_n_video_frame_number[ 1 ]              > 0 ) { fps[  1 ] = (g_d_video_stop_sample_time[ 1 ]              - g_d_video_start_sample_time[ 1 ]             ) / (g_n_video_frame_number[ 1 ]); }

		if( g_n_video_frame_number[ 2 ]              > 0 ) { fps[  2 ] = (g_d_video_stop_sample_time[ 2 ]              - g_d_video_start_sample_time[ 2 ]             ) / (g_n_video_frame_number[ 2 ]); }

		if( g_n_video_frame_number[ 3 ]              > 0 ) { fps[  3 ] = (g_d_video_stop_sample_time[ 3 ]              - g_d_video_start_sample_time[ 3 ]             ) / (g_n_video_frame_number[ 3 ]); }

		if( g_n_video_main_encoder_frame_number[ 0 ] > 0 ) { fps[  4 ] = (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) / (g_n_video_main_encoder_frame_number[ 0 ]); }

		if( g_n_video_main_encoder_frame_number[ 1 ] > 0 ) { fps[  5 ] = (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) / (g_n_video_main_encoder_frame_number[ 1 ]); }

		if( g_n_video_main_encoder_frame_number[ 2 ] > 0 ) { fps[  6 ] = (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) / (g_n_video_main_encoder_frame_number[ 2 ]); }

		if( g_n_video_main_encoder_frame_number[ 3 ] > 0 ) { fps[  7 ] = (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) / (g_n_video_main_encoder_frame_number[ 3 ]); }

		if( (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) > 0 ) { bps[  4 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 0 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) > 0 ) { bps[  5 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 1 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) > 0 ) { bps[  6 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 2 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) > 0 ) { bps[  7 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 3 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) / 100.0; }

		SC540_DEBUG( "FPS = |%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|", fps[ 0 ], fps[ 1 ], fps[ 2 ], fps[ 3 ], fps[ 4 ], fps[ 5 ], fps[ 6 ], fps[ 7 ], fps[ 8 ], fps[ 9 ], fps[ 10 ], fps[ 11 ] );

		SC540_DEBUG( "BPS = |%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|", bps[ 0 ], bps[ 1 ], bps[ 2 ], bps[ 3 ], bps[ 4 ], bps[ 5 ], bps[ 6 ], bps[ 7 ], bps[ 8 ], bps[ 9 ], bps[ 10 ], bps[ 11 ] );

		SC540_DEBUG( "NUM = |%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|", g_n_video_frame_number[ 0 ], g_n_video_frame_number[ 1 ], g_n_video_frame_number[ 2 ], g_n_video_frame_number[ 3 ], g_n_video_main_encoder_frame_number[ 0 ], g_n_video_main_encoder_frame_number[ 1 ], g_n_video_main_encoder_frame_number[ 2 ], g_n_video_main_encoder_frame_number[ 3 ] );

		// GET LOCK DEMO
		//
		for( ULONG i = 0 ; i < 4 ; i++ ) {

			ULONG lock = 0;

			AMESDK_GET_LOCK( m_hVideoDev[ i ], &lock );

		//	SC540_DEBUG( "CH%02d: %d", i + 1, lock );
		}
	}
	*/

	CDialog::OnTimer(nIDEvent);
}

BOOL CSC540Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	// USER INTERFACE RELATED PROGRAMMING
	// 
	{	CBrush brush( RGB( 236, 233, 216 ) );

		CRect rect_client; 

		CRgn rgn_client;

		CRgn rgn_children;

		GetClientRect( &rect_client );

		rgn_client.CreateRectRgn( rect_client.left, rect_client.top, rect_client.right, rect_client.bottom );

		rgn_children.CreateRectRgn( 0, 0, 0, 0 );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_LIVE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_LIVE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_FILE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_FILE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_H264_MAIN[ i ].IsWindowVisible() ) {

				m_oChannelWindow_H264_MAIN[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}

		rgn_client.CombineRgn( &rgn_client, &rgn_children, RGN_XOR );

		pDC->FillRgn( &rgn_client, &brush );
	}
	return TRUE;
	
	return CDialog::OnEraseBkgnd(pDC);
}

void CSC540Dlg::OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	// USER INTERFACE RELATED PROGRAMMING (LIVE/RCPB/RTPB)
	//
	m_nDisplayModeNumber = m_tabDisplayExchange.GetCurSel();

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE

		m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000001 ) { // RCPB

		m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ], FALSE ); // QUAD

		#if ( SC540_RECORD_PLAYBACK_METHOD == 0 )

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] );

		#endif

		m_oChannelWindow_FILE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000002 ) { // RTPB

		m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );
	}

	m_oSetupDialog.OnSelChangeTabDisplay_SC540Dlg( m_nDisplayModeNumber );

   *pResult = 0;
}

BOOL CSC540Dlg::OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	// USER INTERFACE RELATED PROGRAMMING (LIVE MODE)
	//
	if( nChannelNumber == 0x00000001 ||

		nChannelNumber == 0x00000002 ||

		nChannelNumber == 0x00000003 ||

		nChannelNumber == 0x00000004 ) {

		nChannelNumber -= 0x00000001;

		CRect rect;
	
		m_oChannelWindow_LIVE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 480 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }
		}
	}

	// USER INTERFACE RELATED PROGRAMMING (RCPB MODE)
	//
	#if ( SC540_RECORD_PLAYBACK_METHOD == 0 )	

	if( nChannelNumber == 0x10000001 ||

		nChannelNumber == 0x10000002 ||

		nChannelNumber == 0x10000003 ||

		nChannelNumber == 0x10000004 ) {

		nChannelNumber -= 0x10000001;

		CRect rect;
	
		m_oChannelWindow_FILE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 480 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
	}

	#endif

	// USER INTERFACE RELATED PROGRAMMING (RTPB MODE)
	//
	#if ( SC540_REALTIME_PLAYBACK_ENABLE == 1 )	

	if( nChannelNumber == 0x20000001 ||

		nChannelNumber == 0x20000002 ||

		nChannelNumber == 0x20000003 ||

		nChannelNumber == 0x20000004 ) {

		nChannelNumber -= 0x20000001;

		CRect rect;
	
		m_oChannelWindow_H264_MAIN[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 480 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_04_960[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_04_960[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_04_960[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_04_960[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_01_960[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] ); }
		}
	}

	#endif

	return TRUE;
}

BOOL CSC540Dlg::OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	return TRUE;
}

BOOL CSC540Dlg::OnSync_SetupDialog()
{
	return TRUE;
}

BOOL CSC540Dlg::OnSnapshot_SetupDialog()
{
	// SNAPSHOT FUNCTION PROGRAMMING
	//
	CHAR path[ MAX_PATH ];

	CHAR psz[ MAX_PATH ];

	SYSTEMTIME system_times; 
	
	GetLocalTime( &system_times );

	m_oSetupDialog.GetRecordPathParameters( path );

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE
	
		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 3 ], psz, 80 );
	}

	#if ( SC540_RECORD_PLAYBACK_METHOD == 0 )

	if( m_nDisplayModeNumber == 0x00000001 ) { // RTCB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hFileSourceDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 3 ], psz, 80 );
	}

	#endif

	if( m_nDisplayModeNumber == 0x00000002 ) { // RTPB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoMainEncoderDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 3 ], psz, 80 );
	}

	return TRUE;
}

BOOL CSC540Dlg::OnApply_SetupDialog()
{
	// RESET DEVICE RESOURCE
	//
	HwUnInitialize();

	HwInitialize();

	return TRUE;
}

BOOL CSC540Dlg::OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber )
{
	// UNINITIALIZE FILE SOURCE RESOURCE
	//
	if( m_hFileSourceDev[ nChannelNumber ] != 0xFFFFFFFF ) { 
		
		AMESDK_DESTROY( m_hFileSourceDev[ nChannelNumber ] ); 
		
		m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
	}
	return TRUE;
}

BOOL CSC540Dlg::OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo )
{
	// INITIALIZE FILE SOURCE RESOURCE (PLAYING & PRELOAD)
	//
	ULONG deinterlace[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

	#if ( SC540_RECORD_PLAYBACK_METHOD == 0 )

		if( m_hFileSourceDev[ nChannelNumber ] == 0xFFFFFFFF ) {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "Common Analog File Source %s", pFileInfo->m_pszFileName );

			// THE TWO LOCATIONS OF POOL ARE USED TO PLAYING & PRELOAD ALGORITHM
			// 
			m_hFileSourceDev[ nChannelNumber ] = AMESDK_CREATE( psz, nChannelNumber, 2 /*FILE SOURCE*/, m_oChannelWindow_FILE[ nChannelNumber ].m_hWnd, NULL, NULL );

			if( m_hFileSourceDev[ nChannelNumber ] & 0x80000000 ) {

				m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF;
			}
			AMESDK_SET_DEINTERLACE( m_hFileSourceDev[ nChannelNumber ], deinterlace[ nChannelNumber ] );
		}

	#endif

	return TRUE;
}

BOOL CSC540Dlg::OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_RUN( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC540Dlg::OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_PAUSE( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC540Dlg::OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STOP( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC540Dlg::OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STEP( m_hFileSourceDev[ nChannelNumber ], nSteps );
}

BOOL CSC540Dlg::OnFileSourceGetVideoStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_VIDEO_STREAM_BUFFER( m_hFileSourceDev[ nChannelNumber ], nSample, pStreamBuffer, pStreamBufferSize );
}

BOOL CSC540Dlg::OnFileSourceGetAudioStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_AUDIO_STREAM_BUFFER( m_hFileSourceDev[ nChannelNumber ], nSample, pStreamBuffer, pStreamBufferSize );
}

BOOL CSC540Dlg::OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_VIDEO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp, pIsKeyFrame );
}

BOOL CSC540Dlg::OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_AUDIO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp );
}

LONGLONG CSC540Dlg::OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nLength = 0;

	AMESDK_FILE_GET_MEDIA_LENGTH( m_hFileSourceDev[ nChannelNumber ], &nLength, dwTimeUnits );

	return nLength;
}

LONGLONG CSC540Dlg::OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nPosition = 0;

	AMESDK_FILE_GET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], &nPosition, dwTimeUnits );

	return nPosition;
}

BOOL CSC540Dlg::OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], nPosition, dwTimeUnits );
}

double CSC540Dlg::OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber )
{
	// GENERAL FILE SOURCE OPERATION
	//
	double dRate = 0;

	AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], &dRate );

	return dRate;
}

BOOL CSC540Dlg::OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate )
{
	// GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], dRate );
}
